(function() {
  //    FILE:Object Collection
  //    PROJECT:fw-mobile
  //    Created by Rafa Dorado on 10/18/13
  //    Farmerswife SL.
  define(['jquery', 'Backbone', 'Backbone.LocalStorage', 'moment', 'models/objects/ObjectModel', 'models/request/RequestModel'], function($, Backbone, LocalStorage, Moment, ObjectModel, RequestModel) {
    var ObjectCollection;
    return ObjectCollection = (function() {
      class ObjectCollection extends Backbone.Collection {
        initialize() {
          this.reqMdl = new RequestModel();
          if (window.localStorage.getItem('SimpleObjects')) {
            return this.fetch();
          }
        }

        get_favorites_objects(usr) {
          var jsonReq, response, that, timeStamp, xmlReq;
          jsonReq = this.reqMdl.get('JGetFavorites');
          timeStamp = usr.get('objectlistfavorites_updated_at');
          if (!timeStamp) {
            timeStamp = Moment().format('YYYY-MM-DD hh:mm:ss');
          }
          this.reqMdl.__setNodeValue(jsonReq, 'sessionID', usr.get('sessionID'));
          this.reqMdl.__setNodeValue(jsonReq, 'cacheTimeStamp', timeStamp);
          xmlReq = this.reqMdl.__getXML(jsonReq);
          that = this;
          response = this.reqMdl.__send_server_xmlrequest(xmlReq);
          response.done(function(data, textStatus, jqXHR) {
            var favForAdding, favForExtras, favForViewing, jsonObj, objects, ref;
            jsonObj = data;
            if (jsonObj.Result.isError === "0" || jsonObj.Result.isError === 0) {
              if (((ref = jsonObj.Result) != null ? ref.cacheIsUpToDate : void 0) === 1) {
                return that.trigger('collectionFavObjectsFilled');
              } else {
                favForViewing = jsonObj.Result.FavoritesForViewingEvents.ObjectID;
                if (!_.isArray(favForViewing)) {
                  favForViewing = [jsonObj.Result.FavoritesForViewingEvents.ObjectID];
                }
                favForAdding = jsonObj.Result.FavoritesForAddingToEvents.ObjectID;
                if (!_.isArray(favForAdding)) {
                  favForAdding = [jsonObj.Result.FavoritesForAddingToEvents.ObjectID];
                }
                favForExtras = jsonObj.Result.FavoritesForAddingToExtras.ObjectID;
                if (!_.isArray(favForExtras)) {
                  favForExtras = [jsonObj.Result.FavoritesForAddingToExtras.ObjectID];
                }
                objects = {
                  'FavoritesForViewingEvents': favForViewing,
                  'FavoritesForAddingToEvents': favForAdding,
                  'FavoritesForAddingToExtras': favForExtras
                };
                window.localStorage.setItem("FavoriteObjects", JSON.stringify(objects));
                //lS = new LocalStorage('FavoriteObjects')
                //lS.records = objects
                //lS.save()
                that.trigger('collectionFavObjectsFilled');
                return usr.save({
                  'objectlistfavorites_updated_at': jsonObj.Result.timeStamp
                });
              }
            } else {
              if (jsonObj.Result.isExpiredSession === '1' || jsonObj.Result.isExpiredSession === 1) {
                window.localStorage.clear();
                return window.location.href = 'index.html?expired=1';
              }
            }
          }).fail(function(data, textStatus, jqXHR) {
            //console.log "ERROR #{textStatus} "+data
            return false;
          });
          return this;
        }

        get_simple_objects(usr) {
          var jsonReq, response, that, timeStamp, xmlReq;
          if (this.models.length > 0) {
            this.trigger('collectionObjectsFilled');
            return;
          }
          jsonReq = this.reqMdl.get('JGetObjectsAndStructures');
          timeStamp = usr != null ? usr.get('objectlist_updated_at') : void 0;
          if (!timeStamp) {
            timeStamp = Moment().format('YYYY-MM-DD hh:mm:ss');
          }
          this.reqMdl.__setNodeValue(jsonReq, 'sessionID', usr.get('sessionID'));
          this.reqMdl.__setNodeValue(jsonReq, 'cacheTimeStamp', timeStamp);
          xmlReq = this.reqMdl.__getXML(jsonReq);
          that = this;
          response = this.reqMdl.__send_server_xmlrequest(xmlReq);
          response.done(function(data, textStatus, jqXHR) {
            var cache, i, jsonObj, len, m, objectClasses, objectFolders, objects, ref, ref1;
            jsonObj = data;
            //CHECK IF CACHE IS UP TO DATE
            cache = ((ref = jsonObj.Result) != null ? ref.cacheIsUpToDate : void 0) != null;
            if (cache === true) {
              that.fetch();
              return that.trigger('collectionObjectsFilled');
            } else {
              if (jsonObj.Result.isError === "0" || jsonObj.Result.isError === 0) {
                objects = jsonObj.Result.O;
                //SET THIS COLLECTION OF OBJECTS
                if (that.models.length > 0) {
                  ref1 = that.models;
                  for (i = 0, len = ref1.length; i < len; i++) {
                    m = ref1[i];
                    that.remove(m);
                  }
                  that.create(objects, {
                    silent: true
                  });
                } else if (that.models.length === 0) {
                  that.create(objects, {
                    silent: true
                  });
                }
                //CREATE A SEPARATE LOCALSTORAGE ITEM FOR HANDLING FOLDERS  (SAME AS FAVORITES)
                objectFolders = _.isArray(jsonObj.Result.OF) ? jsonObj.Result.OF : [jsonObj.Result.OF];
                objectClasses = _.isArray(jsonObj.Result.OC) ? jsonObj.Result.OC : [jsonObj.Result.OC];
                window.localStorage.setItem("ObjectFolders", JSON.stringify(objectFolders));
                window.localStorage.setItem("ObjectClasses", JSON.stringify(objectClasses));
                that.trigger('collectionObjectsFilled');
                return usr.save({
                  'objectlist_updated_at': jsonObj.Result.timeStamp
                });
              } else {
                if (jsonObj.Result.isExpiredSession === '1' || jsonObj.Result.isExpiredSession === 1) {
                  window.localStorage.clear();
                  return window.location.href = 'index.html?expired=1';
                }
              }
            }
          }).fail(function(data, textStatus, jqXHR) {
            //console.log "ERROR #{textStatus} "+data
            return false;
          }).always(function(data, textStatus) {
            return $.mobile.loading('hide');
          });
          return this;
        }

        findByName(subStringContact, context) {
          var col, res;
          res = [];
          if (this.models.length > 1) {
            col = this.toJSON();
          } else {
            col = this.models[0].toJSON();
          }
          _.each(col, (obj) => {
            var name;
            if (this.is_object_viewable(obj, context)) {
              if (obj.name) {
                name = (obj != null ? obj.name : void 0) + '';
                if (name.toLowerCase().indexOf(subStringContact.toLowerCase()) !== -1) {
                  return res.push(obj);
                }
              }
            }
          });
          return res;
        }

        findById(objectID, context) {
          var col, res;
          res = null;
          if (this.models.length > 1) {
            col = this.toJSON();
          } else {
            col = this.models[0].toJSON();
          }
          _.each(col, (obj) => {
            if (objectID === obj.objectID) {
              return res = obj;
            }
          });
          return res;
        }

        is_object_folder_viewable(objF, context) {
          var col, viewable;
          viewable = false;
          if (this.models.length > 1) {
            col = this.toJSON();
          } else {
            col = this.models[0].toJSON();
          }
          if (context === 'EventsViewing') {
            _.each(objF.OFM.objectID, function(memberID) {
              var obj;
              obj = _.findWhere(col, {
                objectID: memberID
              });
              if ((obj != null ? obj.canView : void 0) === 1) {
                return viewable = true;
              }
            });
          }
          if (context === 'TimereportExtra' || 'AdhocInvolved') {
            _.each(objF.OFM.objectID, function(memberID) {
              var obj;
              obj = _.findWhere(col, {
                objectID: memberID
              });
              if ((obj != null ? obj.canBeAddedToTimereport : void 0) === 1) {
                return viewable = true;
              }
            });
          }
          if (context === 'TaskInvolved' || 'BookingInvolved') {
            _.each(objF.OFM.objectID, function(memberID) {
              var obj, ref, ref1;
              obj = _.findWhere(col, {
                objectID: memberID
              });
              if ((ref = obj != null ? obj.type : void 0) !== 'smartEventsView' && ref !== 'service' && ref !== 'material' && ref !== 'expense') {
                if ((ref1 = obj != null ? obj.createTasks : void 0) === 'yes' || ref1 === 'onlyAsRequest') {
                  return viewable = true;
                }
              }
            });
          }
          return viewable;
        }

        is_object_viewable(obj, context) {
          var ref, ref1, viewable;
          viewable = false;
          if (context === 'EventsViewing') {
            if ((obj != null ? obj.canView : void 0) === 1) {
              viewable = true;
            }
          }
          if (context === 'TimereportExtra' || 'AdhocInvolved') {
            if ((obj != null ? obj.canBeAddedToTimereport : void 0) === 1) {
              viewable = true;
            }
          }
          if (context === 'TaskInvolved') {
            if ((obj != null ? obj.type : void 0) !== 'smartEventsView') {
              if ((ref = obj.createTasks) === 'yes' || ref === 'onlyAsRequest') {
                viewable = true;
              }
            }
          }
          if (context === 'BookingInvolved') {
            if ((obj != null ? obj.type : void 0) !== 'smartEventsView') {
              if ((ref1 = obj.createBookings) === 'yes' || ref1 === 'onlyAsRequest') {
                viewable = true;
              }
            }
          }
          return viewable;
        }

        get_favorites_from_context(context) {
          var all;
          all = JSON.parse(window.localStorage.getItem('FavoriteObjects'));
          if (context === 'EventsViewing') {
            return all.FavoritesForViewingEvents;
          } else if (context === 'TimereportExtra') {
            return all.FavoritesForAddingToExtras;
          } else if (context === 'TaskInvolved' || context === 'BookingInvolved' || context === 'AdhocInvolved') {
            return all.FavoritesForAddingToEvents;
          }
        }

        add_favorite_with_context(obj, context) {
          var all;
          all = JSON.parse(window.localStorage.getItem('FavoriteObjects'));
          if (context === 'EventsViewing') {
            all.FavoritesForViewingEvents.push(obj.get('objectID'));
          } else if (context === 'TimereportExtra') {
            all.FavoritesForAddingToExtras.push(obj.get('objectID'));
          } else if (context === 'TaskInvolved' || context === 'BookingInvolved' || context === 'AdhocInvolved') {
            all.FavoritesForAddingToEvents.push(obj.get('objectID'));
          }
          return window.localStorage.setItem("FavoriteObjects", JSON.stringify(all));
        }

        remove_favorite_with_context(obj, context) {
          var all, favForAdding, favForExtras, favForViewing, objects;
          all = JSON.parse(window.localStorage.getItem('FavoriteObjects'));
          favForViewing = all.FavoritesForViewingEvents;
          favForAdding = all.FavoritesForAddingToEvents;
          favForExtras = all.FavoritesForAddingToExtras;
          if (context === 'EventsViewing') {
            favForViewing = _.without(all.FavoritesForViewingEvents, obj.get('objectID'));
          } else if (context === 'TimereportExtra' || 'AdhocInvolved') {
            favForExtras = _.without(all.FavoritesForAddingToExtras, obj.get('objectID'));
          } else if (context === 'TaskInvolved' || context === 'BookingInvolved' || context === 'AdhocInvolved') {
            favForAdding = _.without(all.FavoritesForAddingToEvents, obj.get('objectID'));
          }
          objects = {
            'FavoritesForViewingEvents': favForViewing,
            'FavoritesForAddingToEvents': favForAdding,
            'FavoritesForAddingToExtras': favForExtras
          };
          return window.localStorage.setItem("FavoriteObjects", JSON.stringify(objects));
        }

      };

      ObjectCollection.prototype.model = ObjectModel;

      ObjectCollection.prototype.localStorage = new LocalStorage('SimpleObjects');

      return ObjectCollection;

    }).call(this);
  });

}).call(this);
